//
//  GHRecordData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 11/1/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHRecordData class provides detailed information about a data record
 *  recorded by the device during a User initiated activity.
 */
@interface GHRecordData : NSObject <NSCoding>

/** Latitude in degrees for the record. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *latitude;

/** Longitude in degrees for the record. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *longitude;

/** Altitude in meters. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *altitude;

/** Heart Rate in beats per minute (BPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *heartRate;

/** Cadence in revolutions per minute (RPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *cadence;

/** Distance in meters. If invalid the value will be LONG_MAX. */
@property (nullable, nonatomic, readonly) NSNumber *distance;

/** Speed in meters per second (m/s). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *speed;


@end
